/*
	BDS Welcome Page - Content Loader Module

	Copyright (c) 2004, 2005 Borland Software Corporation

	Written by Daniel Wischnewski, Borland SE Germany.
	Co-Admin of www.delphipraxis.net -- The German Delphi Community
	Email: dwischnewski@gatenetwork.com
*/

var clientIsOnline;
var clientUsesProxy;
var clientProxyString;
var clientProxyUser;
var clientProxyPassword;
var clientAppDataFolder;
var appPath;
var wpPath;
var xmlPath;
var xslPath;
var fileSystemObject;
var xmlPersonal;
var xmlRssCache;
var currentFeed;

var debug;
var radBlog;

debug = false;
radblog = "";

function debugAlert(msg)
{
	if (debug)
	{
		alert(msg);
	}
}

function displayDate()
{
	var date;

	date = new Date();
	dateInfo.innerHTML = date.toLocaleDateString();
}

function selectCurrentFeed()
{
	var rssFeeds;

	rssFeeds = document.getElementById("rssFeeds");
	for (var i = 0; i < rssFeeds.options.length; i++)
	{
		if (rssFeeds.options[i].value.indexOf(currentFeed) >= 0)
		{
			rssFeeds.selectedIndex = i;
		}
	}
}

function savePersonalSettings()
{
	var settingsFile;

	settingsFile = clientAppDataFolder + '\\welcomePageSettings.xml';
	xmlPersonal.save(settingsFile);
}

function saveRssCache()
{
	var settingsFile;

	settingsFile = clientAppDataFolder + '\\rssCache.xml';
	xmlRssCache.save(settingsFile);
}

function setClientIsOnline(state)
{
	clientIsOnline = state;
	try
	{
		if (clientIsOnline)
		{
			offline.style.visibility = 'hidden';
		} else {
			offline.style.visibility = 'visible';
		}
	} catch(e) {
	}
}

function checkRadBlog()
{
	var xmlHTTP;

	try
	{
		if ((radBlog != "") && clientIsOnline)
		{
			xmlHTTP = getXmlHttpDoc();
			xmlHTTP.setTimeouts(500, 500, 500, 500);
			try
			{
				xmlHTTP.open("GET", radBlog, false);
				xmlHTTP.send();
				if (xmlHTTP.status == 200)
					return 0;
			} catch (e) {
			}
		}
	} catch(e) {
	}
	radBlog = "";
}

function loadRadEntry(rssFeeds)
{
	var channel;
	var item;

	if (radBlog != "")
	{
		channel = rssFeeds.documentElement.insertBefore(rssFeeds.createElement("channel"), rssFeeds.documentElement.selectSingleNode("channel"));
		getSubNode(channel, "title").text = "Internal Feed";
		item = getSubNode(channel, "item");
		getSubNode(item, "title").text = "Radblog";
		getSubNode(item, "reload").text = "0";
		getSubNode(item, "link").text = radBlog;
	}
	return rssFeeds;
}

function initializePage()
{
	// initialize application variables
	clientIsOnline = external.Application.IsOnline;
	clientUsesProxy = external.Application.UsesProxy;
	clientProxyString = external.Application.ProxyString;
	clientUserAgentString = external.Application.UserAgent;
	clientAppDataFolder = external.Application.AppDataFolder;
	clientProxyUser = '';
	clientProxyPassword = '';

	// determine path variables
	appPath = external.Application.ExeName;
	appPath = appPath.substr(0, appPath.lastIndexOf('\\'));
	appPath = appPath.substr(0, appPath.lastIndexOf('\\') + 1);
	wpPath = appPath + 'WelcomePage\\';
	xmlPath = wpPath + 'XML\\';
	xslPath = wpPath + 'XSL\\';
	fileSystemObject = new ActiveXObject("Scripting.FileSystemObject");

	// load settings
	xmlPersonal = loadXmlDocSafe(clientAppDataFolder + '\\welcomePageSettings.xml');
	xmlRssCache = loadXmlDocSafe(clientAppDataFolder + '\\rssCache.xml');

	// load rss feeds
	checkRadBlog();
	displayRss(document.getElementById('toolBar'), loadLocalXmlDoc('toolBar.xml'), loadLocalXslDoc('toolBar.xsl'));
	displayRss(mainMenu, loadLocalXmlDoc('menuBar.xml'), loadLocalXslDoc('menuBar.xsl'));
	displayRss(rssHeaderForm, loadRadEntry(loadLocalXmlDoc('rssFeeds.xml')), loadLocalXslDoc('rssSelect.xsl'));

	// load recent projects
	renderProjectsModule();

	// display current date and update ones a minute, so those night falks will be happy too
	loadLanguageStrings();
	displayDate();
	window.setInterval('displayDate();', 60000);

	// load default rss feed
	displayDefaultRss();
	selectCurrentFeed();

	setClientIsOnline(clientIsOnline);
}
